package com.mobiuz.app.dev.ui.auth

import android.util.Log
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mobiuz.app.dev.model.UserAuth
import com.mobiuz.app.dev.network.model.Action
import com.mobiuz.app.dev.network.model.ChangePassword
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.network.repository.AuthRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class AuthViewModel @Inject constructor(
    private val repository: AuthRepository
) : ViewModel() {

    private val _checkPhoneUiState = MutableSharedFlow<UiStateObject<Action>>()
    val checkPhoneUiState: SharedFlow<UiStateObject<Action>> = _checkPhoneUiState

    fun checkPhone(data: UserAuth) = viewModelScope.launch {
        _checkPhoneUiState.emit(UiStateObject.LOADING)
        _checkPhoneUiState.emit(repository.checkPhone(data))
    }

    private val _registerUiState = MutableSharedFlow<UiStateObject<String>>()
    val registerUiState: SharedFlow<UiStateObject<String>> = _registerUiState

    fun register(data: UserAuth) = viewModelScope.launch {
        _registerUiState.emit(UiStateObject.LOADING)
        _registerUiState.emit(repository.registerUser(data))
    }

    private val _verificationUiState = MutableSharedFlow<UiStateObject<String>>()
    val verificationUiState: SharedFlow<UiStateObject<String>> = _verificationUiState

    fun verification(data: UserAuth) = viewModelScope.launch {
        _verificationUiState.emit(UiStateObject.LOADING)
        _verificationUiState.emit(repository.checkSMSCode(data))
    }

    private val _loginUiState = MutableSharedFlow<UiStateObject<String>>()
    val loginUiState: SharedFlow<UiStateObject<String>> = _loginUiState

    fun login(data: UserAuth) = viewModelScope.launch {
        _loginUiState.emit(UiStateObject.LOADING)
        _loginUiState.emit(repository.loginUser(data))
    }

    private val _forgetPasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val forgetPasswordUiState: SharedFlow<UiStateObject<String>> = _forgetPasswordUiState

    fun forgetPassword(data: UserAuth) = viewModelScope.launch {
        _forgetPasswordUiState.emit(UiStateObject.LOADING)
        _forgetPasswordUiState.emit(repository.forgetPassword(data))
    }

    private val _checkResetCodeUiState = MutableSharedFlow<UiStateObject<String>>()
    val checkResetCodeUiState: SharedFlow<UiStateObject<String>> = _checkResetCodeUiState

    fun checkResetCode(data: UserAuth) = viewModelScope.launch {
        _checkResetCodeUiState.emit(UiStateObject.LOADING)
        _checkResetCodeUiState.emit(repository.checkResetCode(data))
    }

    private val _resetPasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val resetPasswordUiState: SharedFlow<UiStateObject<String>> = _resetPasswordUiState

    fun resetPassword(data: UserAuth) = viewModelScope.launch {
        _resetPasswordUiState.emit(UiStateObject.LOADING)
        _resetPasswordUiState.emit(repository.resetPassword(data))
    }

    private val _resetSmsCodeUiState = MutableSharedFlow<UiStateObject<String>>()
    val resetSmsCodeUiState: SharedFlow<UiStateObject<String>> = _resetSmsCodeUiState

    fun resetSmsCode(data: UserAuth) = viewModelScope.launch {
        _resetSmsCodeUiState.emit(UiStateObject.LOADING)
        _resetSmsCodeUiState.emit(repository.resetSmsCode(data))
    }

    private val _checkPasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val checkPasswordUiState: SharedFlow<UiStateObject<String>> = _checkPasswordUiState

    fun checkPassword(data: UserAuth) = viewModelScope.launch {
        _checkPasswordUiState.emit(UiStateObject.LOADING)
        _checkPasswordUiState.emit(repository.checkPassword(data))
    }

    private val _changePasswordUiState = MutableSharedFlow<UiStateObject<String>>()
    val changePasswordUiState: SharedFlow<UiStateObject<String>> = _changePasswordUiState

    fun changePassword(data: ChangePassword) = viewModelScope.launch {
        _changePasswordUiState.emit(UiStateObject.LOADING)
        _changePasswordUiState.emit(repository.installPassword(data))
    }


}