package com.mobiuz.app.dev.network.model


sealed class UiStateList<out T> {
    data class SUCCESS<out T>(val data: List<T>) : UiStateList<T>()
    data class ERROR(val message: String, var fromServer: Boolean = false) : UiStateList<Nothing>()
    data class ERRORS(val errors: List<Errors>) : UiStateObject<Nothing>()
    object LOADING : UiStateList<Nothing>()
    object EMPTY : UiStateList<Nothing>()
}