package com.mobiuz.app.dev.ui.auth

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mobiuz.app.dev.model.UserAuth
import com.mobiuz.app.dev.network.model.Action
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.network.repository.AuthRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class AuthViewModel @Inject constructor(
    private val repository: AuthRepository
) : ViewModel() {

    private val _checkPhoneUiState = MutableStateFlow<UiStateObject<Action>>(UiStateObject.EMPTY)
    val checkPhoneUiState: StateFlow<UiStateObject<Action>> = _checkPhoneUiState

    fun checkPhone(data: UserAuth) = viewModelScope.launch {
        _checkPhoneUiState.value = UiStateObject.LOADING
        _checkPhoneUiState.value = repository.checkPhone(data)
        _checkPhoneUiState.value = UiStateObject.EMPTY
    }

    private val _registerUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val registerUiState: StateFlow<UiStateObject<String>> = _registerUiState

    fun register(data: UserAuth) = viewModelScope.launch {
        _registerUiState.value = UiStateObject.LOADING
        _registerUiState.value = repository.registerUser(data)
        _registerUiState.value = UiStateObject.EMPTY
    }

    private val _verificationUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val verificationUiState: StateFlow<UiStateObject<String>> = _verificationUiState

    fun verification(data: UserAuth) = viewModelScope.launch {
        _verificationUiState.value = UiStateObject.LOADING
        _verificationUiState.value = repository.checkSMSCode(data)
        _verificationUiState.value = UiStateObject.EMPTY
    }

    private val _loginUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val loginUiState: StateFlow<UiStateObject<String>> = _loginUiState

    fun login(data: UserAuth) = viewModelScope.launch {
        _loginUiState.value = UiStateObject.LOADING
        _loginUiState.value = repository.loginUser(data)
        _loginUiState.value = UiStateObject.EMPTY
    }

    private val _forgetPasswordUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val forgetPasswordUiState: StateFlow<UiStateObject<String>> = _forgetPasswordUiState

    fun forgetPassword(data: UserAuth) = viewModelScope.launch {
        _forgetPasswordUiState.value = UiStateObject.LOADING
        _forgetPasswordUiState.value = repository.forgetPassword(data)
        _forgetPasswordUiState.value = UiStateObject.EMPTY
    }

    private val _checkResetCodeUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val checkResetCodeUiState: StateFlow<UiStateObject<String>> = _checkResetCodeUiState

    fun checkResetCode(data: UserAuth) = viewModelScope.launch {
        _checkResetCodeUiState.value = UiStateObject.LOADING
        _checkResetCodeUiState.value = repository.checkResetCode(data)
        _checkResetCodeUiState.value = UiStateObject.EMPTY
    }

    private val _resetPasswordUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val resetPasswordUiState: StateFlow<UiStateObject<String>> = _resetPasswordUiState

    fun resetPassword(data: UserAuth) = viewModelScope.launch {
        _resetPasswordUiState.value = UiStateObject.LOADING
        _resetPasswordUiState.value = repository.resetPassword(data)
        _resetPasswordUiState.value = UiStateObject.EMPTY
    }
}