package com.mobiuz.app.dev.ui.auth.biometric

import android.Manifest
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Build
import android.os.Bundle
import android.view.View
import androidx.core.app.ActivityCompat.requestPermissions
import androidx.core.content.ContextCompat
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.BuildConfig
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentBiometricBinding
import com.mobiuz.app.dev.MainActivity
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.ui.global.CONSTANTS
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class BiometricFragment : BaseFragment(R.layout.fragment_biometric) {

    private var _bn: FragmentBiometricBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    var phone = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if (BuildConfig.VERSION_CODE >= Build.VERSION_CODES.P) {
            if (ContextCompat.checkSelfPermission(requireContext(), Manifest.permission.USE_BIOMETRIC) != PackageManager.PERMISSION_GRANTED) {
                requestPermissions(requireActivity(), arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 101)
            }
        }

    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentBiometricBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {

            btnBack.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    navController.navigateUp()
                }
            })

            txtSkip.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    navigate()
                }
            })

            btnNext.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    navigate()
                }
            })

            btnSwitch.setOnCheckedChangeListener { buttonView, isChecked ->

            }


        }
    }

    private fun navigate() {
        val intent = Intent(requireContext(), MainActivity::class.java)
        intent.putExtra(CONSTANTS.FIRST, CONSTANTS.FIRST)
        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
        startActivity(intent)
        requireActivity().finish()
    }

    override fun collects() {}

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}