package com.mobiuz.app.dev.ui.auth.check

import android.os.Bundle
import android.view.View
import android.view.animation.AnimationUtils
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentCheckPhoneBinding
import com.mobiuz.app.dev.model.UserAuth
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.ui.auth.AuthViewModel
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.ui.global.TextWatcherWrapper
import com.mobiuz.app.dev.utils.Utils
import com.mobiuz.app.dev.utils.extensions.customLog
import com.mobiuz.app.dev.utils.extensions.showCustomDialog
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect

@AndroidEntryPoint
class CheckPhoneFragment : BaseFragment(R.layout.fragment_check_phone) {

    private var _bn: FragmentCheckPhoneBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    var phone = ""
    var phoneRaw = ""

    private val viewModel: AuthViewModel by viewModels()

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentCheckPhoneBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {

            inputPhone.addTextChangedListener(object : TextWatcherWrapper() {
                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    super.onTextChanged(s, start, before, count)
                    customLog("s=${s?.toString()?.length}")
                    bn.helperPhone.isVisible = false
                    btnLogin.isEnabled = inputPhone.text.toString().trim().length == 17
                }
            })

            btnLogin.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    phone = "+998" + inputPhone.unmaskedText.toString().trim()
                    phoneRaw = inputPhone.text.toString().trim()
                    when {
                        phone.length < 13 -> {
                            inputPhone.startAnimation(AnimationUtils.loadAnimation(requireContext(), R.anim.shake))
                        }
                        else -> viewModel.checkPhone(UserAuth(phone.replace("+", "")))
                    }

                }
            })
            toolbar.setNavigationOnClickListener {
                requireActivity().finish()
            }
        }
    }

    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.checkPhoneUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {
                        showProgressDialog(false)
                        bn.helperPhone.isVisible = false
                        if (it.data.action == "login") {
                            navController.navigate(R.id.loginFragment, bundleOf(CONSTANTS.PHONE to phoneRaw), Utils.navOptions())
                        } else if (it.data.action == "register") {
                            navController.navigate(R.id.registerFragment, bundleOf(CONSTANTS.PHONE to phone), Utils.navOptions())
                        }
                    }
                    is UiStateObject.ERROR -> {
                        bn.helperPhone.isVisible = false
                        showProgressDialog(false)
                        showCustomDialog(it.message, false) {}
                    }

                    is UiStateObject.ERRORS -> {
                        it.errors.forEach {
                            if (it.key == "phone") {
                                bn.layoutInput.startAnimation(AnimationUtils.loadAnimation(requireContext(), R.anim.shake))
                                bn.helperPhone.isVisible = true
                                bn.helperPhone.text = it.message
                            }
                        }
                        showProgressDialog(false)

                    }
                    is UiStateObject.LOADING -> {
                        bn.helperPhone.isVisible = false
                        showProgressDialog(true)
                    }
                    else -> Unit
                }
            }
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}