package uz.mobiuz.mobiservice.dev

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.app.AppCompatDelegate
import dagger.hilt.android.AndroidEntryPoint
import uz.agr.sdk.pgw_core.mobi.MobiUz
import uz.mobiuz.mobiservice.dev.databinding.ActivityLanguageBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.ui.auth.AuthActivity
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import javax.inject.Inject

@AndroidEntryPoint
class LanguageActivity : AppCompatActivity() {

    private var _bn: ActivityLanguageBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityLanguageBinding.inflate(layoutInflater)
        setContentView(bn.root)
        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO)
        bn.apply {
            uzbekLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.UZ)
            }
            russianLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.RU)
            }
            englishLang.setOnClickListener {
                setLangAndNavigate(CONSTANTS.EN)
            }
        }
    }

    private fun setLangAndNavigate(lang: String) {
        pref.language = lang
        MobiUz.setLanguage(this, lang)
        startActivity(Intent(this, AuthActivity::class.java))
        finish()
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}