package com.mobiuz.app.dev.ui.settings

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.View
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentSupportBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject


@AndroidEntryPoint
class SupportFragment : BaseFragment(R.layout.fragment_support) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentSupportBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentSupportBinding.bind(view)
        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
                requireActivity().finish()
            }
            btn0890.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:0890"))
                    requireActivity().startActivity(intent)
                }
            })
            btnPhone1.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:+998971300909"))
                    requireActivity().startActivity(intent)
                }
            })
            btnPhone2.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:+998972031010"))
                    requireActivity().startActivity(intent)
                }
            })
            btnHelpBot.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            btnSentMessage.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
        }
    }


    override fun collects() {
    }


    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}