package uz.ssd.mobiuz

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.biometric.BiometricManager
import androidx.biometric.BiometricPrompt
import androidx.core.hardware.fingerprint.FingerprintManagerCompat
import dagger.hilt.android.AndroidEntryPoint
import uz.ssd.mobiuz.databinding.ActivityAuthBinding
import uz.ssd.mobiuz.utils.extensions.customLog

@AndroidEntryPoint
class AuthActivity : AppCompatActivity() {

    private var _bn: ActivityAuthBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityAuthBinding.inflate(layoutInflater)
        setContentView(bn.root)

        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
//        val bio = BiometricManager.from(this).canAuthenticate()
//        val man = FingerprintManagerCompat.from(this)
//       val manager = man.isHardwareDetected && man.hasEnrolledFingerprints()
//        customLog("bio:$bio $manager")
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}