package uz.ssd.mobiuz.ui.auth

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import uz.ssd.mobiuz.model.UserAuth
import uz.ssd.mobiuz.network.model.Action
import uz.ssd.mobiuz.network.model.UiStateObject
import uz.ssd.mobiuz.network.repository.AuthRepository
import javax.inject.Inject

@HiltViewModel
class AuthViewModel @Inject constructor(
    private val repository: AuthRepository
) : ViewModel() {

    private val _loginUiState = MutableStateFlow<UiStateObject<Action>>(UiStateObject.EMPTY)
    val loginUiState: StateFlow<UiStateObject<Action>> = _loginUiState

    fun login(data: UserAuth) = viewModelScope.launch {
        _loginUiState.value = UiStateObject.LOADING
        _loginUiState.value = repository.loginUser(data)
        _loginUiState.value = UiStateObject.EMPTY
    }

    private val _registerUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val registerUiState: StateFlow<UiStateObject<String>> = _registerUiState

    fun register(data: UserAuth) = viewModelScope.launch {
        _registerUiState.value = UiStateObject.LOADING
        _registerUiState.value = repository.registerUser(data)
    }

    private val _verificationUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val verificationUiState: StateFlow<UiStateObject<String>> = _verificationUiState

    fun verification(data: UserAuth) = viewModelScope.launch {
        _verificationUiState.value = UiStateObject.LOADING
        _verificationUiState.value = repository.checkSMSCode(data)
    }
}