package uz.ssd.mobiuz

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.NavController
import androidx.navigation.findNavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import uz.ssd.mobiuz.databinding.ActivityAuthBinding
import uz.ssd.mobiuz.utils.CONSTANTS
import uz.ssd.mobiuz.utils.Utils

@AndroidEntryPoint
class AuthActivity : AppCompatActivity() {

    private var _bn: ActivityAuthBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var navController : NavController

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityAuthBinding.inflate(layoutInflater)
        setContentView(bn.root)
        val fragment = supportFragmentManager.findFragmentById(R.id.auth_container)  as NavHostFragment
        navController = NavHostFragment.findNavController(fragment)

        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

        intent?.let {
            val type = it.getStringExtra(CONSTANTS.TYPE_AUTH)
            if (type == CONSTANTS.PIN_CODE) {
                navController.popBackStack()
                navController.navigate(R.id.pinFragment,null,Utils.navOptions())
            }
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}