package uz.ssd.mobiuz.ui.home

import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import uz.ssd.mobiuz.AuthActivity
import uz.ssd.mobiuz.MainActivity
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.FragmentHomeBinding
import uz.ssd.mobiuz.model.SharedPref
import uz.ssd.mobiuz.network.model.Customer
import uz.ssd.mobiuz.network.model.UiStateObject
import uz.ssd.mobiuz.ui.base.BaseFragment
import uz.ssd.mobiuz.utils.ButtonClick
import uz.ssd.mobiuz.utils.CONSTANTS
import uz.ssd.mobiuz.utils.Utils
import uz.ssd.mobiuz.utils.extensions.showCustomExitDialog
import uz.ssd.mobiuz.utils.extensions.showMessage
import uz.ssd.mobiuz.utils.extensions.toMoneyFormat
import javax.inject.Inject


@AndroidEntryPoint
class HomeFragment : BaseFragment(R.layout.fragment_home) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentHomeBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel : HomeViewModel by viewModels()

    private var customer: Customer? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        viewModel.mainIndex()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentHomeBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            btnMenu.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    showCustomExitDialog {
                        pref.setUserToken("")
                        pref.isRegistered = false
                        pref.pin_code = ""
                        val intent = Intent(requireContext(), AuthActivity::class.java)
                        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                        startActivity(intent)
                        requireActivity().finish()
                    }
                }
            })
            btnAddSum.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {

                }
            })
        }
    }

    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.mainIndexUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {
                        showProgressDialog(false)
                        customer = it.data
                        loadData()
                    }
                    is UiStateObject.ERROR -> {
                        showProgressDialog(false)
                        showMessage(it.message)
                    }

                    is UiStateObject.ERRORS -> {
                        showProgressDialog(false)
                    }
                    is UiStateObject.LOADING -> {
                        showProgressDialog(true)
                    }
                    else -> Unit
                }
            }
        }
    }

    @SuppressLint("SetTextI18n")
    private fun loadData() {
        customer?.customer?.info?.let {
            bn.apply {
                txtBalance.text = "${it.balance.amount.toMoneyFormat()} ${it.balance.currency}"
                it.counters.let {
                    txtCountMb.text = it.BYTE.value.toMoneyFormat()
                    txtTypeMb.text = it.BYTE.unit

                    txtCountMinut.text = it.SECOND.value.toMoneyFormat()
                    txtTypeMinut.text = it.SECOND.unit

                    txtCountSms.text = it.ITEM.value.toMoneyFormat()
                    txtTypeSms.text = it.ITEM.unit
                }
                txtMyNumber.text = pref.userPhone
            }
        }

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}