package uz.ssd.mobiuz.utils.extensions

import android.app.Activity
import android.content.Context
import android.util.Log
import android.widget.Toast
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.RecyclerView
import com.google.gson.JsonSyntaxException
import retrofit2.HttpException
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.ui.base.ExitDialog
import java.io.IOException
import java.net.ConnectException


fun Fragment.showMessage(message: String) {
    Toast.makeText(requireContext(), message, Toast.LENGTH_SHORT).show()
}

fun Activity.showMessage(message: String) {
    Toast.makeText(this, message, Toast.LENGTH_SHORT).show()
}


fun Fragment.customLog(message: Any) {
    Log.e("AAA", message.toString())
}

fun Activity.customLog(message: Any) {
    Log.e("AAA", message.toString())
}

fun RecyclerView.customLog(message: Any) {
    Log.e("AAA", message.toString())
}


fun Throwable.userMessage(context: Context) = when (this) {
    is HttpException -> when (this.code()) {
        304 -> context.getString(R.string.ex304)
        400 -> context.getString(R.string.ex400)
        401 -> context.getString(R.string.ex401)
        403 -> context.getString(R.string.ex403)
        404 -> context.getString(R.string.ex404)
        405 -> context.getString(R.string.ex405)
        406 -> context.getString(R.string.ex406)
        408 -> context.getString(R.string.ex408)
        409 -> context.getString(R.string.ex409)
        413 -> context.getString(R.string.ex413)
        422 -> context.getString(R.string.ex422)
        429 -> context.getString(R.string.ex429)
        500 -> context.getString(R.string.ex500)
        502 -> context.getString(R.string.ex502)
        else -> context.getString(R.string.exelse)
    }
    is IOException -> context.getString(R.string.ioexception)
    is JsonSyntaxException -> context.getString(R.string.jsonsyntaxexception)
    is ConnectException -> context.getString(R.string.connect_exception)
    else -> context.getString(R.string.ex_nothing)
}

fun Fragment.showCustomExitDialog(block: () -> Unit) {
    val dialog = ExitDialog()
    dialog.setOnDoneListener {
        block()
    }
    dialog.show(childFragmentManager, "childFragmentManager")
}

typealias SingleBlock<T> = (T) -> Unit
typealias MultiBlock<T, K> = (T, K) -> Unit
typealias ThreeBlock<T, K, M> = (T, K, M) -> Unit
