package com.mobiuz.app.dev.ui.settings.safety

import android.os.Bundle
import android.view.View
import android.widget.SeekBar
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.airbnb.lottie.utils.Utils
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentSafetyBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.utils.extensions.showMessage
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class SafetyFragment : BaseFragment(R.layout.fragment_safety) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentSafetyBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentSafetyBinding.bind(view)
        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
                requireActivity().finish()
            }
            switchBiometria.isChecked = pref.isUseFingerPrint
            switchBiometria.setOnCheckedChangeListener { _, isChecked ->
                val message = if(isChecked) "Biometric enabled" else "Biometric disabled"
                showToastMessage(message)
                pref.isUseFingerPrint = isChecked
            }
            btn1.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            btnChangePin.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            btnChangePassword.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    navController.navigate(R.id.currentPasswordFragment,null,com.mobiuz.app.dev.utils.Utils.navOptions())
                }
            })
            btn4.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            btn5.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                }
            })
            seekbar.setOnSeekBarChangeListener(object : SeekBar.OnSeekBarChangeListener{
                override fun onProgressChanged(seekBar: SeekBar?, progress: Int, fromUser: Boolean) {

                }

                override fun onStartTrackingTouch(seekBar: SeekBar?) {

                }

                override fun onStopTrackingTouch(seekBar: SeekBar?) {
                    showMessage("${seekBar}")
                }
            })
        }
    }


    override fun collects() {
    }


    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}