package com.mobiuz.app.dev


import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.network.repository.MainRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class MainViewModel @Inject constructor(
    private val repository: MainRepository
) : ViewModel() {

    private val _userNameUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val userNameUiState: StateFlow<UiStateObject<String>> = _userNameUiState

    fun setUserName(name: String) {
        _userNameUiState.value = UiStateObject.SUCCESS(name)
    }

    private val _mainIndexUiState = MutableStateFlow<UiStateObject<Long>>(UiStateObject.EMPTY)
    val mainIndexUiState: StateFlow<UiStateObject<Long>> = _mainIndexUiState

    fun openDrawer(time: Long) = viewModelScope.launch {
        _mainIndexUiState.value = UiStateObject.SUCCESS(time)
    }

    private val _servicesUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val servicesUiState: StateFlow<UiStateObject<String>> = _servicesUiState

    fun services() = viewModelScope.launch {
        _servicesUiState.value = UiStateObject.LOADING
        _servicesUiState.value = repository.services()
    }

    private val _bottomSheetUiState = MutableStateFlow<UiStateObject<Boolean>>(UiStateObject.EMPTY)
    val bottomSheetUiState: StateFlow<UiStateObject<Boolean>> = _bottomSheetUiState

    fun bottomSheet(status: Boolean) = viewModelScope.launch {
        _bottomSheetUiState.value = UiStateObject.EMPTY
        _bottomSheetUiState.value = UiStateObject.SUCCESS(status)
    }

    private val _swipeDrawerUiState = MutableStateFlow<UiStateObject<Boolean>>(UiStateObject.EMPTY)
    val swipeDrawerUiState: StateFlow<UiStateObject<Boolean>> = _swipeDrawerUiState

    fun swipeDrawer(status: Boolean) = viewModelScope.launch {
        _swipeDrawerUiState.value = UiStateObject.EMPTY
        _swipeDrawerUiState.value = UiStateObject.SUCCESS(status)
    }

    suspend fun logOut() = repository.logOut()


}