package com.mobiuz.app.dev.ui.home

import android.os.Bundle
import android.view.View
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentBillingBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.utils.extensions.showMessage
import dagger.hilt.android.AndroidEntryPoint
import uz.agr.mobiuz.AGRBilling
import javax.inject.Inject

@AndroidEntryPoint
class BillingFragment : BaseFragment(R.layout.fragment_billing) {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentBillingBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController by lazy (LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentBillingBinding.bind(view)
        setUpUI()
        val window = requireActivity().window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
    }


     override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
               navController.navigateUp()
            }

            savedCards.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(
                            AGRBilling.createCardsListIntent(requireContext(), pref.userPhone.filter { it.isDigit() })
                        )
                    }
                })
            }
            payments.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        /*
                        Vendor(
                100082, "OOO UMS", "UMS", "https://agr.uz/application/resources/img/ums.jpg"
            )
                         */
                        startActivity(
                            AGRBilling.createReplenishBalanceIntent(requireContext(), phoneNumber)
                        )
                    }
                })
            }
            monitoring.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(
                            AGRBilling.createHistoryIntent(requireContext(), phoneNumber)
                        )
                    }
                })
            }
        }
    }

    override fun collects() {}

    private fun getPhoneNumber(listener: LoadPhoneNumber) {
        val number = pref.userPhone.filter { it.isDigit() }
        if (number.length == 12) {
            listener.invoke(number)
        } else {
            showMessage("Invalid phone number")
        }
    }

    private interface LoadPhoneNumber {
        fun invoke(phoneNumber: String)
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}