package com.mobiuz.app.dev.ui.home

import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.mobiuz.app.R
import com.mobiuz.app.databinding.ItemHomeBinding
import com.mobiuz.app.dev.network.model.Events
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.utils.extensions.SingleBlock

class SliderAdapter : RecyclerView.Adapter<SliderAdapter.SliderViewHolder>() {

    private var listener: SingleBlock<String>? = null
    private val sliderItems: ArrayList<String> = ArrayList()

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SliderViewHolder {
        return SliderViewHolder(
            ItemHomeBinding.inflate(LayoutInflater.from(parent.context), parent, false)
        )
    }

    override fun onBindViewHolder(holder: SliderViewHolder, position: Int) = holder.onBind(position)

    override fun getItemCount(): Int = 4

    inner class SliderViewHolder(val view: ItemHomeBinding) : RecyclerView.ViewHolder(view.root) {

        fun onBind(position: Int) {
            view.apply {
                if(position % 2 != 0){
                    imageSlider.setImageResource(R.drawable.image_slider2)
                    txtDescription.setTextColor(Color.WHITE)
                    txtDescription.text = itemView.context.getString(R.string.misic_all_with_you)
                }
                btnSeeMore.setOnClickListener(object : ButtonClick() {
                    override fun onSingleClick(v: View?) {
                        listener?.invoke(CONSTANTS.HTTP_MOBI_UZ)
                    }
                })

            }
        }

    }

    fun setOnClickListener(block: SingleBlock<String>) {
        listener = block
    }

    fun submitList(ls: List<String>) {
        sliderItems.clear()
        sliderItems.addAll(ls)
        notifyDataSetChanged()
    }
}