package com.mobiuz.app.dev.ui.service

import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.google.gson.Gson
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentSendUssdBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.model.InnerData
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.CONSTANTS
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class SendUssdFragment : BaseFragment(R.layout.fragment_send_ussd) {

    @Inject
    lateinit var pref: SharedPref

    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentSendUssdBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter : UssdAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        adapter = UssdAdapter(pref.language)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
        arguments?.let {
            val arg = it.getString(CONSTANTS.SERVICE) ?: ""
            if (arg.isNotEmpty()){
               val data = Gson().fromJson(arg, InnerData::class.java)
                adapter.submitList(data.data)
            }
        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentSendUssdBinding.bind(view)
        setUpUI()
        collects()

    }


    override fun setUpUI() {
        bn.apply {

//            OverScrollDecoratorHelper.setUpStaticOverScroll(bn.rvUssdCommand, OverScrollDecoratorHelper.ORIENTATION_VERTICAL)
            rvUssdCommand.adapter = adapter

            adapter.setOnClickListener {
                val dialog = UssdBottomSheetDialog(it)
                dialog.show(childFragmentManager, "tag")
            }
        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}