package com.mobiuz.app.dev.ui.service

import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.lifecycle.ViewModelProvider
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentServicesBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.CONSTANTS
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class ServicesFragment : BaseFragment(R.layout.fragment_services) {

    @Inject
    lateinit var pref: SharedPref
    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentServicesBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter: ServicesAdapter
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    private var type = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
        adapter = ServicesAdapter(pref.language)
        arguments?.let {
            type = it.getString(CONSTANTS.TYPE_SERVICE) ?: ""

        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentServicesBinding.bind(view)
        setUpUI()
        collects()

        val window = requireActivity().window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

    }

    override fun onResume() {
        super.onResume()
        mainViewModel.bottomSheet(true)
        mainViewModel.swipeDrawer(true)
    }

    override fun onStop() {
        super.onStop()
        mainViewModel.bottomSheet(false)
        mainViewModel.swipeDrawer(false)
    }



    override fun setUpUI() {
        bn.apply {


            checkType(type == CONSTANTS.OFFLINE)

            rvService.adapter = adapter

            val list = Gson().fromJson<List<ServiceData>>(pref.services, object : TypeToken<List<ServiceData>>() {}.type)
            adapter.submitList(list)

//            OverScrollDecoratorHelper.setUpStaticOverScroll(bn.rvService, OverScrollDecoratorHelper.ORIENTATION_VERTICAL)
            adapter.setOnClickListener {
                navigateToServiceScreen(it)
            }

            toolbar.setNavigationOnClickListener {
                mainViewModel.openDrawer(System.currentTimeMillis())
            }
        }
    }

    private fun checkType(b: Boolean) {
        bn.apply {
            toolbar.isVisible = !b
            txtDostupno.isVisible = b
            layoutOffline.isVisible = b
        }
    }


    private fun navigateToServiceScreen(key: ServiceData) {
        navController.navigate(R.id.ussdFragment, bundleOf(CONSTANTS.SERVICE to Gson().toJson(key)))
        mainViewModel.bottomSheet(false)
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}