package com.mobiuz.app.dev.ui.service

import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import androidx.viewpager2.adapter.FragmentStateAdapter
import com.google.gson.Gson
import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.ui.global.CONSTANTS

class ServicesPagerAdapter(fragment: Fragment, private val service: ServiceData): FragmentStateAdapter(fragment) {
    override fun getItemCount() = service.data.size

    override fun createFragment(position: Int): Fragment {
        return SendUssdFragment().apply {
            this.arguments = bundleOf(CONSTANTS.SERVICE to Gson().toJson(service.data[position]))
        }
    }
}