package uz.ssd.mobiuz.ui.auth

import android.Manifest
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Build
import android.os.Bundle
import android.view.View
import androidx.core.app.ActivityCompat
import androidx.core.app.ActivityCompat.requestPermissions
import androidx.core.content.ContextCompat
import androidx.core.os.bundleOf
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import uz.ssd.mobiuz.BuildConfig
import uz.ssd.mobiuz.MainActivity
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.FragmentBiometricBinding
import uz.ssd.mobiuz.network.model.UiStateObject
import uz.ssd.mobiuz.ui.base.BaseFragment
import uz.ssd.mobiuz.utils.ButtonClick
import uz.ssd.mobiuz.utils.CONSTANTS
import uz.ssd.mobiuz.utils.Utils
import uz.ssd.mobiuz.utils.extensions.showMessage

@AndroidEntryPoint
class BiometricFragment : BaseFragment(R.layout.fragment_biometric) {

    private var _bn: FragmentBiometricBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    var phone = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if (BuildConfig.VERSION_CODE >= Build.VERSION_CODES.P) {
            if (ContextCompat.checkSelfPermission(requireContext(),Manifest.permission.USE_BIOMETRIC) != PackageManager.PERMISSION_GRANTED) {
                requestPermissions(requireActivity(), arrayOf(Manifest.permission.ACCESS_FINE_LOCATION),101)
            }
        }

    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentBiometricBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {

            btnBack.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    navController.navigateUp()
                }
            })

            txtSkip.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    navigate()
                }
            })

            btnNext.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    navigate()
                }
            })

            btnSwitch.setOnCheckedChangeListener { buttonView, isChecked ->

            }


        }
    }

    private fun navigate() {
        val intent = Intent(requireContext(), MainActivity::class.java)
        intent.putExtra(CONSTANTS.FIRST,CONSTANTS.FIRST)
        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
        startActivity(intent)
        requireActivity().finish()
    }

    override fun collects() {}

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}