package uz.ssd.mobiuz.ui.auth

import android.app.AlertDialog
import android.content.Context
import android.view.LayoutInflater
import android.view.animation.AnimationUtils
import android.widget.TextView
import androidx.core.view.isVisible
import androidx.recyclerview.widget.LinearLayoutManager
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.FragmentPinDialogBinding
import uz.ssd.mobiuz.model.PinData
import uz.ssd.mobiuz.model.SharedPref
import uz.ssd.mobiuz.utils.extensions.SingleBlock


class PinDialogFragment(context: Context) : AlertDialog(context,R.style.FullScreenDialog) {

    lateinit var pref: SharedPref
    private var _bn: FragmentPinDialogBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val data = ArrayList<PinData>()
    private val pinAdapter = PinAdapter()
    private var listener: SingleBlock<Unit>? = null

    init {
        _bn = FragmentPinDialogBinding.inflate(LayoutInflater.from(context))
        pref = SharedPref(context)
        setView(bn.root)

        setCancelable(false)
        setUpUI()
    }


    fun setUpUI() {
        bn.apply {
            loadData()
            rvPin.layoutManager = LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
            rvPin.setHasFixedSize(true)

            rvPin.adapter = pinAdapter
            txtNotPin.isVisible = false
            pinAdapter.setOnDoneListener {
                if (pref.pin_code == it) {
                    listener?.invoke(Unit)
                    txtNotPin.isVisible = false
                    dismiss()
                } else {
                    cardPin.startAnimation(AnimationUtils.loadAnimation(context, R.anim.shake))
                    txtNotPin.isVisible = true
                }


            }

            for (i in 0 until btnViewGroup.childCount) {
                btnViewGroup.getChildAt(i).setOnClickListener {
                    if (it.id == R.id.btn_remove) {
                        pinAdapter.removeItem()
                        txtNotPin.isVisible = false
                    } else {
                        val text = it as TextView
                        pinAdapter.addItem(text.text.toString().toInt())
                    }
                }
            }

        }
    }

    fun setOnPinDoneListener(block: SingleBlock<Unit>) {
        listener = block
    }

    private fun loadData() {
        data.clear()
        for (i in 0..3) {
            data.add(PinData(-1))
        }
        pinAdapter.submitList(data)
    }

}