package com.mobiuz.app.dev.ui.service

import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentActionBinding
import com.mobiuz.app.databinding.FragmentMainUssdBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.ui.base.BaseFragment
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class ActionFragment : BaseFragment(R.layout.fragment_action) {

    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentActionBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val adapter = ActionAdapter()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentActionBinding.bind(view)
        setUpUI()
        collects()

    }


    override fun setUpUI() {
        bn.apply {
            rvUssdCommand.adapter = adapter

            adapter.setOnClickListener {
                val dialog = UssdBottomSheetDialog(UssdData("Переход на тариф","Mobi 20","*111*120#","Перейти"))
                dialog.show(childFragmentManager, "tag")
            }
        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}