package com.mobiuz.app.dev.ui.service

import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.viewpager2.adapter.FragmentStateAdapter
import com.google.gson.Gson
import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.ui.global.CONSTANTS

class FragmentPagerAdapter(fragment: Fragment, private val service: ServiceData): FragmentStateAdapter(fragment) {
    override fun getItemCount() = service.data.size

    override fun createFragment(position: Int): Fragment {
        return ActionFragment().apply {
            this.arguments = bundleOf(CONSTANTS.SERVICE to Gson().toJson(service.data[position]))
        }
    }
}