package com.mobiuz.app.dev

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.ActivityOfflineBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.auth.AuthActivity
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.ui.service.ServiceAdapter
import com.mobiuz.app.dev.utils.NetworkUtil
import com.mobiuz.app.dev.utils.extensions.customLog
import com.mobiuz.app.dev.utils.extensions.showFullScreenDialog
import com.mobiuz.app.dev.utils.extensions.showMessage
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject


@AndroidEntryPoint
class OfflineActivity : AppCompatActivity() {

    private var _bn: ActivityOfflineBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter: ServiceAdapter
    private lateinit var navController: NavController
    private lateinit var receiver: BroadcastReceiver
    // if offline type == 0
    private var type = 0

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityOfflineBinding.inflate(layoutInflater)
        setContentView(bn.root)
        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        adapter = ServiceAdapter(pref.language)
        pref.isShowPin = false

        val fragment = supportFragmentManager.findFragmentById(R.id.offline_container) as NavHostFragment
        navController = NavHostFragment.findNavController(fragment)

        navController.popBackStack()
        navController.navigate(R.id.serviceFragment, bundleOf(CONSTANTS.TYPE_SERVICE to CONSTANTS.OFFLINE))

        receiver = object : BroadcastReceiver(){
            override fun onReceive(context: Context?, intent: Intent?) {
               type  = NetworkUtil.getConnectivityStatus(this@OfflineActivity)
                    bn.btnTryAgain.isVisible = type != 0
                if(type != 0){
                    showMessage(getString(R.string.yes_internet_connect))
                }else{
                    showMessage(getString(R.string.not_internet_connect))
                }
            }
        }
        val intentFilter = IntentFilter("android.net.conn.CONNECTIVITY_CHANGE")
        registerReceiver(receiver,intentFilter)

        bn.btnTryAgain.setOnClickListener {
            if (type != 0){
                navigate()
            }
        }

    }
    override fun onResume() {
        super.onResume()
        customLog("onResume: pref.isShowPin:${pref.isShowPin}")
        if (pref.isShowPin && pref.pinCode.isNotEmpty()) {
            showPinCode()
        } else {
            pref.blockedTime = System.currentTimeMillis()
            pref.isShowPin = true
        }
    }

    override fun onStop() {
        super.onStop()
        pref.blockedTime = System.currentTimeMillis()
    }


    private fun showPinCode() {
        showFullScreenDialog {
            finish()
            pref.clearUserData()
            val intent = Intent(this, AuthActivity::class.java)
            intent.putExtra(CONSTANTS.TYPE_AUTH, CONSTANTS.LOGIN)
            intent.putExtra(CONSTANTS.PHONE, pref.userPhone)
            startActivity(intent)
            it.dismiss()
        }
    }

    fun navigate(){
        when {
            !pref.isRegistered -> {
                startActivity(Intent(this, AuthActivity::class.java))
            }

            pref.pinCode.isEmpty() -> {
                startActivity(Intent(this, AuthActivity::class.java).putExtra(CONSTANTS.TYPE_AUTH, CONSTANTS.PIN_CODE))
            }

            else -> {
                val intent = Intent(this, MainActivity::class.java)
                intent.putExtra(CONSTANTS.FIRST, CONSTANTS.FIRST)
                intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                startActivity(intent)
            }
        }
        finish()
    }


    override fun onDestroy() {
        unregisterReceiver(receiver)
        _bn = null
        super.onDestroy()
    }
}