package com.mobiuz.app.dev

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import com.mobiuz.app.databinding.FragmentBillingBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.utils.LocaleHelper
import dagger.hilt.android.AndroidEntryPoint
import uz.agr.mobiuz.AGRBilling
import uz.agr.sdk.coreui.extension.showMessage
import javax.inject.Inject

@AndroidEntryPoint
class BillingActivity : AppCompatActivity() {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentBillingBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    override fun onCreate(savedInstanceState: Bundle?) {
        LocaleHelper.setLocale(this)
        super.onCreate(savedInstanceState)
        _bn = FragmentBillingBinding.inflate(layoutInflater)
        setContentView(bn.root)

        val window = window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

        setUpUI()
    }

     fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
                finish()
            }

            AGRBilling.hasCards().subscribe({
                showMessage("Has Cards")
            }, {
                showMessage("No Card")
            }).dispose()

            savedCards.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(
                            AGRBilling.createCardsListIntent(this@BillingActivity, pref.userPhone.filter { it.isDigit() })
                        )
                    }
                })
            }
            payments.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        /*
                        Vendor(
                100082, "OOO UMS", "UMS", "https://agr.uz/application/resources/img/ums.jpg"
            )
                         */
                        startActivity(
                            AGRBilling.createReplenishBalanceIntent(this@BillingActivity, phoneNumber)
                        )
                    }
                })
            }
            monitoring.setOnClickListener {
                getPhoneNumber(object : LoadPhoneNumber {
                    override fun invoke(phoneNumber: String) {
                        pref.isShowPin = false
                        startActivity(
                            AGRBilling.createHistoryIntent(this@BillingActivity, phoneNumber)
                        )
                    }
                })
            }
        }
    }




    private fun getPhoneNumber(listener: LoadPhoneNumber) {
        val number = pref.userPhone.filter { it.isDigit() }
        if (number.length == 12) {
            listener.invoke(number)
        } else {
            showMessage("Invalid phone number")
        }
    }

    private interface LoadPhoneNumber {
        fun invoke(phoneNumber: String)
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}