package com.mobiuz.app.dev.ui.service

import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.BottomSheetUssdBinding
import com.mobiuz.app.databinding.FragmentMainUssdBinding
import com.mobiuz.app.dev.ui.global.ButtonClick

class UssdBottomSheetDialog(val data: UssdData) : BottomSheetDialogFragment() {
    private var _bn: BottomSheetUssdBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        _bn = BottomSheetUssdBinding.inflate(inflater)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = BottomSheetUssdBinding.bind(view)
        bn.apply {
            data.apply {
                txtTitle.text = this.title
                txtTarif.text = this.tariff
                txtCode.text = this.code
                btnZapros.text = this.text_button
            }
            btnZapros.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    dismiss()
                }
            })
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }

}