package com.mobiuz.app.dev.ui.service.ussd


import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.mobiuz.app.databinding.ItemUssdBinding
import com.mobiuz.app.dev.model.PinData
import com.mobiuz.app.dev.utils.extensions.SingleBlock

class MainUssdAdapter : RecyclerView.Adapter<MainUssdAdapter.VHolder>() {

    private val list: ArrayList<PinData> by lazy { ArrayList() }
    private var listener: SingleBlock<String>? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): VHolder {
        return VHolder(ItemUssdBinding.inflate(LayoutInflater.from(parent.context)))
    }

    override fun onBindViewHolder(holder: VHolder, position: Int) = holder.bind(position)
    override fun getItemCount() = 16

    inner class VHolder(private val binding: ItemUssdBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(position: Int) {
            itemView.setOnClickListener {
                listener?.invoke("")
            }
//            val d = list[position]
//            binding.imagePin.setImageResource(if (d.count == -1) R.drawable.ic_pin_unchecked else R.drawable.ic_pin_checked)
        }
    }

    fun submitList(ls: List<PinData>) {
        list.clear()
        list.addAll(ls)
        notifyDataSetChanged()
    }


    fun setOnClickListener(block: SingleBlock<String>) {
        listener = block
    }

}