package uz.mobiuz.mobiservice.dev.network.repository

import android.content.Context
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.withContext
import uz.mobiuz.mobiservice.dev.model.Monitoring
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.model.database.MonitoringDao
import uz.mobiuz.mobiservice.dev.network.api.ApiService
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class CardRepository @Inject constructor(
    private val apiService: ApiService,
    private val dao: MonitoringDao,
    private val pref: SharedPref,
    @ApplicationContext val context: Context
) {

    suspend fun addMonitoring(data: Monitoring) {
        withContext(Dispatchers.IO) {
            dao.addMonitoring(data)
        }
    }

    fun getAllMonitoring(): Flow<List<Monitoring>> {
        return dao.getAllMonitoring()

    }


}
