package uz.mobiuz.mobiservice.dev.ui.sdk.card

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import uz.agr.sdk.core.entity.card.CardInfo
import uz.agr.sdk.core.entity.card.CardRegistration
import uz.agr.sdk.mobi_uz.BaseListener
import uz.agr.sdk.mobi_uz.CardListener
import uz.agr.sdk.mobi_uz.AGRBilling
import uz.mobiuz.mobiservice.dev.network.model.UiStateList
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.network.repository.MainRepository
import javax.inject.Inject

@HiltViewModel
class CardViewModel @Inject constructor(
    private val repository: MainRepository
) : ViewModel() {

    private val _cardListUiState = MutableSharedFlow<UiStateList<CardInfo>>()
    val cardListUiState: SharedFlow<UiStateList<CardInfo>> = _cardListUiState

    fun getAllCards() = viewModelScope.launch {
        _cardListUiState.emit(UiStateList.LOADING)
        AGRBilling.getAllCards(object : CardListener<CardInfo> {
            override fun error(message: String) {
                viewModelScope.launch {
                    _cardListUiState.emit(UiStateList.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {}

            override fun local(localData: List<CardInfo>) {
                viewModelScope.launch {
                    _cardListUiState.emit(UiStateList.SUCCESS(localData))
                }
            }

            override fun server(serverData: List<CardInfo>) {
                viewModelScope.launch {
                    _cardListUiState.emit(UiStateList.SUCCESS(serverData))
                }
            }
        })
    }

    private val _cardRegistrationUiState = MutableSharedFlow<UiStateObject<CardRegistration>>()
    val cardRegistrationUiState: SharedFlow<UiStateObject<CardRegistration>> = _cardRegistrationUiState

    fun cardRegistration(phone: String, card: String, expire: String) = viewModelScope.launch {
        _cardRegistrationUiState.emit(UiStateObject.LOADING)
        AGRBilling.registerCard(phone, card, expire, object : BaseListener<CardRegistration> {
            override fun error(message: String) {
                viewModelScope.launch {
                    _cardRegistrationUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {}

            override fun success(data: CardRegistration) {
                viewModelScope.launch {
                    _cardRegistrationUiState.emit(UiStateObject.SUCCESS(data))
                }
            }
        })
    }

    private val _cardConfirmUiState = MutableSharedFlow<UiStateObject<CardInfo>>()
    val cardConfirmUiState: SharedFlow<UiStateObject<CardInfo>> = _cardConfirmUiState

    fun cardConfirm(cardId: String, code: String) = viewModelScope.launch {
        _cardConfirmUiState.emit(UiStateObject.LOADING)
        AGRBilling.cardConfirmSms(cardId, code, object : BaseListener<CardInfo> {
            override fun error(message: String) {
                viewModelScope.launch {
                    _cardConfirmUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {}

            override fun success(data: CardInfo) {
                viewModelScope.launch {
                    _cardConfirmUiState.emit(UiStateObject.SUCCESS(data))
                }
            }
        })
    }

    private val _resendSmsUiState = MutableSharedFlow<UiStateObject<CardRegistration>>()
    val resendSmsUiState: SharedFlow<UiStateObject<CardRegistration>> = _resendSmsUiState

    fun resendSms(phoneNumber: String, cardNumber: String, cardExpire: String) = viewModelScope.launch {
        _resendSmsUiState.emit(UiStateObject.LOADING)
        AGRBilling.registerCardResendSms(phoneNumber, cardNumber, cardExpire,object : BaseListener<CardRegistration> {
            override fun error(message: String) {
                viewModelScope.launch {
                    _resendSmsUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {}

            override fun success(data: CardRegistration) {
                viewModelScope.launch {
                    _resendSmsUiState.emit(UiStateObject.SUCCESS(data))
                }
            }
        })
    }

    private val _onClickedCardUiState = MutableStateFlow<UiStateObject<Long>>(UiStateObject.EMPTY)
    val onClickedCardUiState: StateFlow<UiStateObject<Long>> = _onClickedCardUiState

    fun onCLickAddCard(time:Long){
        _onClickedCardUiState.value = UiStateObject.SUCCESS(time)
    }


}