package uz.mobiuz.mobiservice.dev.ui.sdk.card

import android.app.AlertDialog
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import uz.agr.sdk.coreui.ui.ButtonClick
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.DialogDeleteCardBinding
import uz.mobiuz.mobiservice.dev.utils.extensions.SingleBlock

class MessageDialogFragment(context: Context, title: String? = null) : AlertDialog(context, R.style.AgrProgressDialogTheme) {
    private val contentView = LayoutInflater.from(context).inflate(R.layout.dialog_delete_card, null, false)
    private var listenerOk: SingleBlock<Int>? = null
    private var binding: DialogDeleteCardBinding
    private var listenerCancel: SingleBlock<Int>? = null

    init {
        setView(contentView)
        binding = DialogDeleteCardBinding.bind(contentView)
        binding.apply {
            if (title != null)
                description.text = title
            btnOk.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    listenerOk?.invoke(1)
                }
            })
            btnCancel.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    listenerCancel?.invoke(1)
                }
            })
        }
    }

    fun setOnOkClickListener(block: SingleBlock<Int>) {
        listenerOk = block
    }

    fun setOnCancelClickListener(block: SingleBlock<Int>) {
        listenerCancel = block
    }
}