package uz.mobiuz.mobiservice.dev.utils.sms

import android.app.AlertDialog
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import androidx.core.view.isVisible
import kotlinx.android.synthetic.main.layout_dialog_message.*
import uz.agr.sdk.coreui.ui.ButtonClick
import uz.mobiuz.mobiservice.dev.R

class MessageDialog(context: Context, title: String? = null, buttonText: String, drawable: Int? = null) : AlertDialog(context, R.style.AgrProgressDialogTheme) {
    private val contentView = LayoutInflater.from(context).inflate(R.layout.layout_dialog_message, null, false)
    private var listenerOk: OnClickListener? = null

    init {
        setView(contentView)
        contentView.apply {
            if (title != null)
                description.text = title
            else description.isVisible = false
            if (drawable != null) {
                image.setImageResource(drawable)
            }
            btnOk.text = buttonText
            btnOk.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    listenerOk?.dialogPositiveClicked()
                }
            })
        }
    }

    fun setOnOkClickListener(event: OnClickListener) {
        listenerOk = event
    }

    interface OnClickListener {
        fun dialogPositiveClicked() {}
    }
}
