package uz.ssd.mobiuz.network.api

import retrofit2.http.Body
import retrofit2.http.POST
import uz.ssd.mobiuz.model.UserAuth
import uz.ssd.mobiuz.network.model.Action
import uz.ssd.mobiuz.network.model.GenerateToken
import uz.ssd.mobiuz.network.model.ResponseList
import uz.ssd.mobiuz.network.model.ResponseObject

interface ApiService {

    @POST("customer/login")
    suspend fun login(
        @Body req: UserAuth
    ): ResponseList<Any>

    @POST("customer/register")
    suspend fun register(
        @Body req: UserAuth
    ): ResponseList<Any>

    @POST("customer/check-phone")
    suspend fun checkPhone(
        @Body req: UserAuth
    ): ResponseObject<Action>

    @POST("customer/check-sms-code")
    suspend fun checkSMSCode(
        @Body req: UserAuth
    ): ResponseObject<GenerateToken>
}