package uz.mobiuz.mobiservice.dev

import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import uz.mobiuz.mobiservice.dev.databinding.ActivityTestBinding
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class TestActivity : AppCompatActivity() {

    private val viewModel: MainViewModel by viewModels()
    private var _bn: ActivityTestBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var navController: NavController

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityTestBinding.inflate(layoutInflater)
        setContentView(bn.root)

        val fragment = supportFragmentManager.findFragmentById(R.id.test_container) as NavHostFragment
        navController = NavHostFragment.findNavController(fragment)

        collects()


    }

    private fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}