package uz.mobiuz.mobiservice.dev.ui.sdk.pay.success

import android.annotation.SuppressLint
import android.os.Bundle
import android.view.View
import androidx.core.view.isVisible
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import uz.agr.mobiuz.ui.fast_action.animation.formatPhone
import uz.agr.sdk.coreui.extension.formattedMoney
import uz.agr.sdk.coreui.extension.showSnackMessage
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.FragmentPaymentSuccessfulBinding
import uz.mobiuz.mobiservice.dev.ui.base.BaseFragment
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import uz.mobiuz.mobiservice.dev.utils.extensions.formatCard

/**
 * Created by DostonbekIbragimov on 06/01/2022.
 */

@AndroidEntryPoint
class PaymentSuccessfulFragment : BaseFragment(R.layout.fragment_payment_successful) {

    private var _bn: FragmentPaymentSuccessfulBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    private var phone = ""
    private var amount = ""
    private var saveCard: Boolean? = null
    private var cardNumber = ""

    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        phone = arguments?.getString(CONSTANTS.PHONE, "") ?: ""
        amount = arguments?.getString(CONSTANTS.PAY_AMOUNT, "0") ?: "0"
        saveCard = arguments?.getBoolean(CONSTANTS.PAY_SAVE_CARD)
        cardNumber = arguments?.getString(CONSTANTS.PAY_CARD_NUMBER, "") ?: ""
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentPaymentSuccessfulBinding.bind(view)
        setUpUI()
        collects()
    }

    @SuppressLint("SetTextI18n")
    override fun setUpUI() {
        bn.apply {
            etAmount.text = "${amount.toLong().formattedMoney(showDecimal = false, tiyinToSum = false)} ${getString(uz.agr.mobiuz.R.string.agr_mobi_uz_curr)}"
            etPhone.text = phone.formatPhone(minus = false)
            if (saveCard == true) {
                showSnackMessage(getString(uz.agr.mobiuz.R.string.agr_mobi_uz_card_added))
                if (cardNumber.isNotEmpty()) {
                    tvPanTitle.isVisible = true
                    etCardPan.text = cardNumber.formatCard()
                }
            }
            if (saveCard == false) {
                showSnackMessage(getString(uz.agr.mobiuz.R.string.agr_mobi_uz_card_not_save))
            }

        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}