package com.mobiuz.app.dev.ui.home

import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.mobiuz.app.R
import com.mobiuz.app.databinding.ItemHomeBinding

class SliderAdapter : RecyclerView.Adapter<SliderAdapter.SliderViewHolder>() {

    private var listener: ((String) -> Unit)? = null
    private val sliderItems: ArrayList<String> = ArrayList()

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SliderViewHolder {
        return SliderViewHolder(
            ItemHomeBinding.inflate(LayoutInflater.from(parent.context),parent,false)
        )
    }

    override fun onBindViewHolder(holder: SliderViewHolder, position: Int) = holder.onBind(position)

    override fun getItemCount(): Int = 4

    inner class SliderViewHolder(val view: ItemHomeBinding) : RecyclerView.ViewHolder(view.root) {

        fun onBind(position: Int) {
            view.apply {
                if(position % 2 != 0){
                    imageSlider.setBackgroundResource(R.drawable.image_slider2)
                    txtDescription.setTextColor(Color.WHITE)
                    txtDescription.text = itemView.context.getString(R.string.misic_all_with_you)
                }
            }
        }

    }

    fun setOnClickListener(block: (String) -> Unit) {
        listener = block
    }

    fun submitList(ls: List<String>) {
        sliderItems.clear()
        sliderItems.addAll(ls)
        notifyDataSetChanged()
    }
}