package com.mobiuz.app.dev.ui.service

import android.Manifest
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.mobiuz.app.databinding.BottomSheetUssdBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.model.UssdData
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.utils.extensions.getCurrentName
import com.mobiuz.app.utils.checkPermission
import dagger.hilt.android.AndroidEntryPoint
import java.lang.Exception
import javax.inject.Inject

@AndroidEntryPoint
class UssdBottomSheetDialog(val data: UssdData) : BottomSheetDialogFragment() {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: BottomSheetUssdBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private var lng = ""

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        _bn = BottomSheetUssdBinding.inflate(inflater)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = BottomSheetUssdBinding.bind(view)
        lng = pref.language
        bn.apply {
            data.apply {
                txtTitle.text = this.title.getCurrentName(lng)
                val dec = this.short_description.getCurrentName(lng)
                txtDescription.isVisible = dec.isNotEmpty()
                txtDescription.text = dec
                txtCode.text = this.code
//                btnZapros.text = this.text_button
            }
            btnZapros.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    pref.isShowPin = false
                    checkPermission(Manifest.permission.CALL_PHONE) {
                        try {
                            pref.isShowPin = false
                            val ussd = data.code.replace("#","") + Uri.encode("#")
                            startActivity(Intent(Intent.ACTION_CALL, Uri.parse("tel:$ussd")))
                        }catch (e:Exception){
                            pref.isShowPin = false
                        }
                        dismiss()
                    }
                }
            })
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        _bn = null
    }

}