package com.mobiuz.app.dev.ui.service

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.lifecycle.ViewModelProvider
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentServiceBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.ui.global.CONSTANTS
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class ServiceFragment : BaseFragment(R.layout.fragment_service) {

    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentServiceBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentServiceBinding.bind(view)
        setUpUI()
        collects()

        val window = requireActivity().window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

    }


    override fun setUpUI() {
        bn.apply {

            toolbar.setNavigationOnClickListener {
                mainViewModel.mainIndex(System.currentTimeMillis())
            }
            btnUsdCommand.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(requireContext(), ServicesActivity::class.java)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                    startActivity(intent)
                }
            })

            btnTarifi.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(requireContext(), ServicesActivity::class.java)
                    intent.putExtra(CONSTANTS.TYPE_SERVICE, CONSTANTS.TARIFFS)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                    startActivity(intent)
                }
            })

            btnPaketi.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(requireContext(), ServicesActivity::class.java)
                    intent.putExtra(CONSTANTS.TYPE_SERVICE, CONSTANTS.PACKETS)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                    startActivity(intent)
                }
            })
            btnMinutesAndSms.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    val intent = Intent(requireContext(), ServicesActivity::class.java)
                    intent.putExtra(CONSTANTS.TYPE_SERVICE, CONSTANTS.MINUTES)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                    startActivity(intent)
                }
            })

        }
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}