package uz.mobiuz.mobiservice.dev.ui.sdk.card

import android.util.Log
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.launch
import uz.agr.sdk.core.entity.card.CardRegistration
import uz.agr.sdk.pgw_core.mobi.BaseListener
import uz.agr.sdk.pgw_core.mobi.MobiUz
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.network.repository.MainRepository
import javax.inject.Inject

@HiltViewModel
class CardViewModel @Inject constructor(
    private val repository: MainRepository
) : ViewModel() {

    private val _cardRegistrationUiState = MutableSharedFlow<UiStateObject<CardRegistration>>()
    val cardRegistrationUiState: SharedFlow<UiStateObject<CardRegistration>> = _cardRegistrationUiState

    fun cardRegistration(phone: String, card: String, expire: String) = viewModelScope.launch {
        MobiUz.registerCard(phone, card, expire, object : BaseListener<CardRegistration> {
            override fun error(message: String) {
                Log.d("TAG", "error: ")
                viewModelScope.launch {
                    _cardRegistrationUiState.emit(UiStateObject.ERROR(message))
                }
            }

            override fun loading(boolean: Boolean) {
                Log.d("TAG", "loading: $boolean ")
                viewModelScope.launch {
                    _cardRegistrationUiState.emit(UiStateObject.LOADING)
                }
            }

            override fun success(data: CardRegistration) {
                Log.d("TAG", "success: ${data.maskedPhoneNumber} ")
                viewModelScope.launch {
                    _cardRegistrationUiState.emit(UiStateObject.SUCCESS(data))
                }
            }
        })
    }


}