package uz.mobiuz.mobiservice.dev.ui.sdk.card

import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import uz.agr.sdk.core.entity.card.CardInfo
import uz.agr.sdk.core.entity.card.CardRegistration
import uz.agr.sdk.pgw_core.mobi.BaseListener
import uz.agr.sdk.pgw_core.mobi.CardListenerMobi
import uz.agr.sdk.pgw_core.mobi.MobiUz
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.FragmentCardsListBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.ui.base.BaseFragment
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import javax.inject.Inject

@AndroidEntryPoint
class CardsListFragment : BaseFragment(R.layout.fragment_cards_list) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentCardsListBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel: CardViewModel by viewModels()
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }

    private var phone = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            phone = it.getString(CONSTANTS.PHONE) ?: ""
        }
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentCardsListBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {

        bn.apply {
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }

            btnAddCard.setOnClickListener {
//                addCard()
                navController.navigate(R.id.addCardFragment)
            }
        }

        MobiUz.hasCards(object : BaseListener<Boolean> {
            override fun error(message: String) {

            }

            override fun loading(boolean: Boolean) {

            }

            override fun success(data: Boolean) {
                getAllCards()
            }
        })
    }

    private fun getAllCards() {
        MobiUz.getAllCards(object : CardListenerMobi<CardInfo> {
            override fun error(message: String) {

            }

            override fun loading(boolean: Boolean) {

            }

            override fun local(localData: List<CardInfo>) {

            }

            override fun server(serverData: List<CardInfo>) {

            }
        })
    }

    private fun addCard() {
        MobiUz.registerCard("998990552109", "8600312917291250", "0325", object : BaseListener<CardRegistration> {
            override fun error(message: String) {
                Log.e("TTT", "error:$message")
            }

            override fun loading(boolean: Boolean) {
                Log.e("TTT", "loading:$boolean")
            }

            override fun success(data: CardRegistration) {
                Log.e("TTT", "success:${data.maskedPhoneNumber}")
            }
        })
    }

    private fun cardConfirm(cardId: String, code: String) {
        MobiUz.cardConfirmSms(cardId, code, object : BaseListener<CardInfo> {
            override fun error(message: String) {

            }

            override fun loading(boolean: Boolean) {

            }

            override fun success(data: CardInfo) {

            }
        })
    }

    private fun delete(card: CardInfo) {
//        MobiUz.deleteCard(card)
    }


    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
//            viewModel.mainIndexUiState.collect {
//                when (it) {
//                    is UiStateObject.SUCCESS -> {
//
//
//                    }
//                    is UiStateObject.ERROR -> {
//
//
//                    }
//                    is UiStateObject.LOADING -> {
//
//
//                    }
//                    else -> Unit
//                }
//            }
        }


    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}