package uz.mobiuz.mobiservice.dev.ui.sdk.pay

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import uz.mobiuz.mobiservice.dev.databinding.LayoutSelectAnotherCardBinding

/**
 * Created by DostonbekIbragimov on 24/12/2021.
 */
class SelectAnotherCard : BottomSheetDialogFragment() {

    private var _bn: LayoutSelectAnotherCardBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")


    private var mListener: Listener? = null

    fun setListener(listener: Listener?) {
        this.mListener = listener
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        _bn = LayoutSelectAnotherCardBinding.inflate(inflater)
        return bn.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setUpUI()
    }


    private fun setUpUI() {
        bn.apply {
            btnAnotherCard.setOnClickListener {
                mListener?.onClickAnotherCard()
                dismiss()
            }
            btnAddCard.setOnClickListener {
                mListener?.onClickAddCard()
                dismiss()
            }
        }
    }

    interface Listener {
        fun onClickAnotherCard()
        fun onClickAddCard()
    }
}