package uz.ssd.mobiuz.ui.auth

import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import uz.ssd.mobiuz.R
import uz.ssd.mobiuz.databinding.FragmentLoginBinding
import uz.ssd.mobiuz.model.UserAuth
import uz.ssd.mobiuz.network.model.UiStateObject
import uz.ssd.mobiuz.ui.base.BaseFragment
import uz.ssd.mobiuz.ui.global.TextWatcherWrapper
import uz.ssd.mobiuz.utils.ButtonClick
import uz.ssd.mobiuz.utils.CONSTANTS
import uz.ssd.mobiuz.utils.Utils
import uz.ssd.mobiuz.utils.extensions.customLog
import uz.ssd.mobiuz.utils.extensions.showMessage

@AndroidEntryPoint
class LoginFragment : BaseFragment(R.layout.fragment_login) {

    private var _bn: FragmentLoginBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    var phone = ""
    var phoneRaw = ""

    private val viewModel: AuthViewModel by viewModels()

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentLoginBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {

            inputPhone.addTextChangedListener(object : TextWatcherWrapper(){
                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    super.onTextChanged(s, start, before, count)
                    customLog("s=${s?.toString()?.length}")
                    btnLogin.isEnabled = inputPhone.text.toString().trim().length == 17
                }
            })

            btnLogin.setOnClickListener(object : ButtonClick() {
                override fun onSingleClick(v: View?) {
                    phone = "+998" + inputPhone.unmaskedText.toString().trim()
                    phoneRaw = inputPhone.text.toString().trim()
                    viewModel.login(UserAuth(phone, "password"))
                }
            })
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
        }
    }

    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.loginUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {
                        showProgressDialog(false)

                        if (phone != "+998949125150") {
                            navController.navigate(R.id.enterPasswordFragment, null, Utils.navOptions())
                        } else {
                            navController.navigate(R.id.passwordFragment, bundleOf(CONSTANTS.PHONE to phoneRaw), Utils.navOptions())
                        }
                    }
                    is UiStateObject.ERROR -> {
                        showProgressDialog(false)
                        showMessage(it.message)
                    }
                    is UiStateObject.LOADING -> {
                        showProgressDialog(true)
                    }
                    else -> Unit
                }
            }
        }
    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}

//fun main(){
//    var ss = -421
//    if(ss.toString().startsWith("-")){
//        ss = ss.toString().replace("-","").toInt()
//        val dd = (ss.toString().reversed().toInt()) * -1
//        print(dd)
//    }else{
//        val dd = ss.toString().reversed().toInt()
//        print(dd)
//    }
//
//}