package com.mobiuz.app.dev



import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mobiuz.app.dev.network.model.Customer
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.network.repository.AuthRepository
import com.mobiuz.app.dev.network.repository.MainRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class MainViewModel @Inject constructor(
    private val repository: MainRepository
) : ViewModel() {

    private val _swipeDrawerUiState = MutableStateFlow<UiStateObject<Boolean>>(UiStateObject.EMPTY)
    val swipeDrawerUiState: StateFlow<UiStateObject<Boolean>> = _swipeDrawerUiState

    fun isSwipeDrawer(swipe: Boolean){
        _swipeDrawerUiState.value = UiStateObject.SUCCESS(swipe)
    }

    private val _userNameUiState = MutableStateFlow<UiStateObject<String>>(UiStateObject.EMPTY)
    val userNameUiState: StateFlow<UiStateObject<String>> = _userNameUiState

    fun setUserName(name: String){
        _userNameUiState.value = UiStateObject.SUCCESS(name)
    }

    private val _mainIndexUiState = MutableStateFlow<UiStateObject<Long>>(UiStateObject.EMPTY)
    val mainIndexUiState: StateFlow<UiStateObject<Long>> = _mainIndexUiState

    fun mainIndex(status:Long) = viewModelScope.launch {
        _mainIndexUiState.value = UiStateObject.SUCCESS(status)
//        _mainIndexUiState.value = repository.mainIndex()
    }

}