package com.mobiuz.app.dev

import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.os.bundleOf
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.ActivityOfflineBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.ui.service.ServiceAdapter
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject


@AndroidEntryPoint
class OfflineActivity : AppCompatActivity() {

    private var _bn: ActivityOfflineBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter: ServiceAdapter
    private lateinit var navController: NavController

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _bn = ActivityOfflineBinding.inflate(layoutInflater)
        setContentView(bn.root)
        window.decorView.systemUiVisibility = window.decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        adapter = ServiceAdapter(pref.language)

        val fragment = supportFragmentManager.findFragmentById(R.id.offline_container) as NavHostFragment
        navController = NavHostFragment.findNavController(fragment)

        navController.popBackStack()
        navController.navigate(R.id.serviceFragment, bundleOf(CONSTANTS.TYPE_SERVICE to CONSTANTS.OFFLINE))


    }


    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}