package uz.mobiuz.mobiservice.dev.ui.sdk.history

import android.annotation.SuppressLint
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.hannesdorfmann.adapterdelegates4.AdapterDelegate
import kotlinx.android.synthetic.main.monitoring_item.view.*
import uz.agr.mobiuz.ui.fast_action.animation.formatCard1
import uz.agr.sdk.coreui.extension.formattedMoney
import uz.agr.sdk.coreui.extension.inflate
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.model.Monitoring
import uz.mobiuz.mobiservice.dev.ui.global.CONSTANTS
import uz.mobiuz.mobiservice.dev.utils.extensions.formatPhone
import java.text.SimpleDateFormat
import java.util.*

class MonitoringDelegate : AdapterDelegate<MutableList<Any>>() {
    private val timeParseFormat = SimpleDateFormat("HHmmss", Locale.getDefault())
    private val timeFormat = SimpleDateFormat("HH:mm", Locale.getDefault())

    override fun isForViewType(items: MutableList<Any>, position: Int) = items[position] is Monitoring

    override fun onCreateViewHolder(parent: ViewGroup): RecyclerView.ViewHolder =
        ViewHolder(parent.inflate(R.layout.monitoring_item))

    override fun onBindViewHolder(items: MutableList<Any>, position: Int, viewHolder: RecyclerView.ViewHolder, payloads: MutableList<Any>) =
        (viewHolder as ViewHolder).bind(items[position] as Monitoring)

    override fun onViewRecycled(holder: RecyclerView.ViewHolder) {
        super.onViewRecycled(holder)
    }

    private inner class ViewHolder(val containerView: View) : RecyclerView.ViewHolder(containerView) {
        private lateinit var history: Monitoring

        @SuppressLint("SetTextI18n", "ResourceAsColor")
        fun bind(history: Monitoring) {
            this.history = history
            containerView.cardPan.text = history.pan.formatCard1()
            containerView.tvAmount.text = "- " + (history.amount * 100).formattedMoney(false) + " " + itemView.context.getString(R.string.agr_mobi_uz_curr)
//            val date = timeFormat.format(history.date)
            val date = CONSTANTS.HOUR_FORMAT.format((Date(history.date)))
            containerView.tvTime.text = date
            containerView.tvTransType.text = history.phone.formatPhone()
        }
    }
}