package uz.mobiuz.mobiservice.dev.utils.extensions

import android.content.Context
import uz.agr.mobiuz.R
import java.text.SimpleDateFormat

/**
 * Created by DostonbekIbragimov on 07/01/2022.
 */

fun String.getDate(context: Context): String {
    val day = SimpleDateFormat("dd").format(this)
    val month = SimpleDateFormat("MM").format(this)
    val year = SimpleDateFormat("yyyy").format(this)

    return "${day.toInt()} ${getMonth(month.toInt(), context)} $year"
}

fun getMonth(month: Int, context: Context): String {
    return when (month) {
        1 -> context.getString(R.string.agr_mobi_uz_month_1)
        2 -> context.getString(R.string.agr_mobi_uz_month_2)
        3 -> context.getString(R.string.agr_mobi_uz_month_3)
        4 -> context.getString(R.string.agr_mobi_uz_month_4)
        5 -> context.getString(R.string.agr_mobi_uz_month_5)
        6 -> context.getString(R.string.agr_mobi_uz_month_6)
        7 -> context.getString(R.string.agr_mobi_uz_month_7)
        8 -> context.getString(R.string.agr_mobi_uz_month_8)
        9 -> context.getString(R.string.agr_mobi_uz_month_9)
        10 -> context.getString(R.string.agr_mobi_uz_month_10)
        11 -> context.getString(R.string.agr_mobi_uz_month_11)
        else -> context.getString(R.string.agr_mobi_uz_month_12)
    }
}