package com.mobiuz.app.dev.ui.base

import android.graphics.Color
import android.os.Bundle
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.fragment.app.Fragment
import com.google.android.material.snackbar.Snackbar
import com.mobiuz.app.dev.ui.global.ProgressDialog


abstract class BaseFragment(private val layoutId: Int) : Fragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(layoutId, container, false)
    }

    protected abstract fun setUpUI()
    protected abstract fun collects()


    protected fun showProgressDialog(progress: Boolean) {
        if (!isAdded) return

        val fragment = childFragmentManager.findFragmentByTag("bf_progress")
        if (fragment != null && !progress) {
            (fragment as ProgressDialog).dismissAllowingStateLoss()
            childFragmentManager.executePendingTransactions()
        } else if (fragment == null && progress) {
            ProgressDialog().show(childFragmentManager, "bf_progress")
            childFragmentManager.executePendingTransactions()
        }
    }

//    protected fun showSnackMessage(message:String){
//        val ssb = SpannableStringBuilder().apply {
//            append(message)
//            setSpan(
//                ForegroundColorSpan(Color.WHITE),
//                0,
//                message.length,
//                Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
//            )
//        }
//        view?.let { Snackbar.make(it, ssb, Snackbar.LENGTH_LONG).show() }
//    }

    protected fun showToastMessage(message:String) {
        Toast.makeText(requireContext(), message, Toast.LENGTH_SHORT).show()
    }
}