package com.mobiuz.app.dev.ui.settings

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.View
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentSupportBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.ButtonClick
import com.mobiuz.app.dev.ui.global.CONSTANTS
import dagger.hilt.android.AndroidEntryPoint
import me.everything.android.ui.overscroll.OverScrollDecoratorHelper
import javax.inject.Inject

@AndroidEntryPoint
class SupportFragment : BaseFragment(R.layout.fragment_support) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentSupportBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentSupportBinding.bind(view)
        setUpUI()
        collects()
    }

    override fun setUpUI() {
        bn.apply {
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }

            OverScrollDecoratorHelper.setUpOverScroll(bn.scrollView)

            txtPhone1.text = CONSTANTS.PHONE1
            txtPhone2.text = CONSTANTS.PHONE2
            txtPhone3.text = CONSTANTS.PHONE3
            txtHelpBot.text = CONSTANTS.HELP_BOT

            btn0890.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    actionDial(CONSTANTS.PHONE1)
                }
            })
            btnPhone1.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    actionDial(CONSTANTS.PHONE2.replace(" ",""))
                }
            })
            btnPhone2.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    actionDial(CONSTANTS.PHONE3.replace(" ",""))
                }
            })
            btnHelpBot.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    actionView("https://t.me/${CONSTANTS.HELP_BOT.replace("@","")}")

                }
            })
            btnSentMessage.setOnClickListener(object : ButtonClick(){
                override fun onSingleClick(v: View?) {
                    actionView(CONSTANTS.FEEDBACK)
                }
            })
        }
    }

    private fun actionDial(url:String){
        val intent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:$url"))
        requireActivity().startActivity(intent)
        pref.isShowPin = false
    }

    private fun actionView(url:String){
        val intent = Intent(Intent.ACTION_VIEW)
        intent.data = Uri.parse(url)
        startActivity(intent)
        pref.isShowPin = false
    }

    override fun collects() {}

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}