package uz.mobiuz.mobiservice.dev.ui.sdk

import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.viewModels
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.flow.collect
import uz.mobiuz.mobiservice.dev.R
import uz.mobiuz.mobiservice.dev.databinding.FragmentMonitoringLocalBinding
import uz.mobiuz.mobiservice.dev.databinding.FragmentReplenishBalanceBinding
import uz.mobiuz.mobiservice.dev.model.SharedPref
import uz.mobiuz.mobiservice.dev.network.model.UiStateObject
import uz.mobiuz.mobiservice.dev.ui.base.BaseFragment
import uz.mobiuz.mobiservice.dev.ui.home.HomeViewModel
import javax.inject.Inject

@AndroidEntryPoint
class ReplenishBalanceFragment : BaseFragment(R.layout.fragment_replenish_balance) {

    @Inject
    lateinit var pref: SharedPref

    private var _bn: FragmentReplenishBalanceBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val viewModel: HomeViewModel by viewModels()
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentReplenishBalanceBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {


    }


    override fun collects() {
        viewLifecycleOwner.lifecycleScope.launchWhenStarted {
            viewModel.mainIndexUiState.collect {
                when (it) {
                    is UiStateObject.SUCCESS -> {


                    }
                    is UiStateObject.ERROR -> {


                    }
                    is UiStateObject.LOADING -> {


                    }
                    else -> Unit
                }
            }
        }


    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}