package com.mobiuz.app.dev.app

import android.content.Context
import androidx.multidex.MultiDex
import androidx.multidex.MultiDexApplication
import com.mobiuz.app.BuildConfig
import dagger.hilt.android.HiltAndroidApp
import toothpick.Toothpick
import toothpick.configuration.Configuration
import uz.agr.sdk.AGRBilling
import uz.agr.sdk.core.di.DI
import uz.agr.sdk.core.model.system.LocaleManager
import uz.agr.sdk.coreui.di.ServerModule
import uz.agr.sdk.di.AppModule

@HiltAndroidApp
class App : MultiDexApplication() {

    override fun onCreate() {
        super.onCreate()
        initToothpick()
        initAppScope()
        AGRBilling.init(this)
    }

    override fun attachBaseContext(base: Context) {
        super.attachBaseContext(LocaleManager.setLocale(base))
        MultiDex.install(this)
    }

    private fun initToothpick() {
        if (BuildConfig.DEBUG) {
            Toothpick.setConfiguration(Configuration.forDevelopment().preventMultipleRootScopes())
        } else {
            Toothpick.setConfiguration(Configuration.forProduction())
        }
    }

    private fun initAppScope() {
        val appScope = Toothpick.openScope(DI.APP_SCOPE)
        appScope.installModules(AppModule())

        val serverScope = Toothpick.openScopes(DI.APP_SCOPE, DI.SERVER_SCOPE)
        serverScope.installModules(ServerModule())
    }
}