package com.mobiuz.app.dev.model

import android.content.Context
import android.content.SharedPreferences
import dagger.hilt.android.qualifiers.ApplicationContext
import javax.inject.Inject

class SharedPref @Inject constructor(@ApplicationContext context: Context) {

    private var mySharedPref: SharedPreferences = context.getSharedPreferences("mobiuz", Context.MODE_PRIVATE)


    fun clearUserData(){
        isRegistered = false
        pinCode = ""
        userName = ""
    }
    fun setDeviceToken(token: String) {
        mySharedPref.edit().putString("device_token", token).apply()
    }

    fun getDeviceToken(): String? {
        return mySharedPref.getString("device_token", null)
    }

    fun setUserToken(token: String?) {
        mySharedPref.edit().putString("user_token", token).apply()
    }

    fun getUserToken(): String? {
        return mySharedPref.getString("user_token", null)
    }

    var language: String
        get() = mySharedPref.getString(::language.name, "") ?: ""
        set(value) {
            mySharedPref.edit().putString(::language.name, value).apply()
        }

    var pinCode: String
        get() = mySharedPref.getString(::pinCode.name, "") ?: ""
        set(value) {
            mySharedPref.edit().putString(::pinCode.name, value).apply()
        }

    var isRegistered: Boolean
        get() = mySharedPref.getBoolean(::isRegistered.name, false)
        set(value) {
            mySharedPref.edit().putBoolean(::isRegistered.name, value).apply()
        }

    var isUseFingerPrint: Boolean
        get() = mySharedPref.getBoolean(::isUseFingerPrint.name, false)
        set(value) {
            mySharedPref.edit().putBoolean(::isUseFingerPrint.name, value).apply()
        }

    var userPhone: String
        get() = mySharedPref.getString(::userPhone.name, "") ?: ""
        set(value) {
            mySharedPref.edit().putString(::userPhone.name, value).apply()
        }

    var userName: String
        get() = mySharedPref.getString(::userName.name, "") ?: ""
        set(value) {
            mySharedPref.edit().putString(::userName.name, value).apply()
        }

    var services: String
        get() = mySharedPref.getString(::services.name, "") ?: ""
        set(value) {
            mySharedPref.edit().putString(::services.name, value).apply()
        }

    var isShowPin: Boolean
        get() = mySharedPref.getBoolean(::isShowPin.name, true)
        set(value) {
            mySharedPref.edit().putBoolean(::isShowPin.name, value).apply()
        }

    var blockedTime: Long
        get() = mySharedPref.getLong(::blockedTime.name, 0)
        set(value) {
            mySharedPref.edit().putLong(::blockedTime.name, value).apply()
        }
}